"use client";

import { useState } from "react";
import { createCompany } from "@/app/actions";

export default function AddCompanyModal({ onClose }: { onClose: () => void }) {
    const [name, setName] = useState("");
    const [template, setTemplate] = useState("#agency #design");
    const [loading, setLoading] = useState(false);

    const handleSubmit = async (e: React.FormEvent) => {
        e.preventDefault();
        if (!name.trim()) return;

        setLoading(true);
        try {
            await createCompany(name, template);
            onClose();
        } finally {
            setLoading(false);
        }
    };

    return (
        <div className="fixed inset-0 z-50 flex items-center justify-center bg-black/50 p-4">
            <div className="w-full max-w-md bg-white rounded-xl shadow-2xl p-6 space-y-4">
                <h3 className="text-xl font-bold text-zinc-900">Yeni Firma Ekle</h3>

                <form onSubmit={handleSubmit} className="space-y-4">
                    <div>
                        <label className="block text-sm font-medium mb-1 text-zinc-700">Firma Adı</label>
                        <input
                            type="text"
                            required
                            className="w-full rounded-md border border-zinc-300 p-2 text-zinc-900"
                            placeholder="Örn: Artiz Creative"
                            value={name}
                            onChange={(e) => setName(e.target.value)}
                        />
                    </div>

                    <div>
                        <label className="block text-sm font-medium mb-1 text-zinc-700">Sabit Alt Metin (Şablon)</label>
                        <textarea
                            required
                            rows={4}
                            className="w-full rounded-md border border-zinc-300 p-2 text-zinc-900 font-mono text-sm"
                            placeholder="#hashtagler ve imza..."
                            value={template}
                            onChange={(e) => setTemplate(e.target.value)}
                        />
                    </div>

                    <div className="flex justify-end gap-2 pt-2">
                        <button
                            type="button"
                            onClick={onClose}
                            className="px-4 py-2 text-sm font-medium text-zinc-600 hover:bg-zinc-100 rounded-md"
                        >
                            İptal
                        </button>
                        <button
                            type="submit"
                            disabled={loading}
                            className="px-4 py-2 text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 rounded-md disabled:opacity-50"
                        >
                            {loading ? "Ekleniyor..." : "Kaydet"}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    );
}
