import { NextResponse } from "next/server";
import type { NextRequest } from "next/server";

export function middleware(request: NextRequest) {
    const authCookie = request.cookies.get("auth_session");
    const { pathname } = request.nextUrl;

    // Allow static files and login page
    if (
        pathname.startsWith("/_next") ||
        pathname.startsWith("/static") ||
        pathname === "/login" ||
        pathname.includes(".") // Files like favicon.ico, images
    ) {
        return NextResponse.next();
    }

    // Check if authenticated
    if (!authCookie || authCookie.value !== "valid") {
        const url = request.nextUrl.clone();
        url.pathname = "/login";
        return NextResponse.redirect(url);
    }

    return NextResponse.next();
}

export const config = {
    matcher: ["/((?!api|_next/static|_next/image|favicon.ico).*)"],
};
